/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private Timer workTimer_ = null;
    private HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;
    public Runnable macOSTerminationRequestRunnable = new Runnable(this){

        @Override
        public void run() {
        }
    };

    private CefApp(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        super(args);
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        if (appHandler_ == null) {
            appHandler_ = this;
        }
        if (!this.N_PreInitialize()) {
            throw new IllegalStateException("Failed to pre-initialize native code");
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) throws UnsatisfiedLinkError {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        if (settings != null && CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            self = new CefApp(args, settings);
            CefApp.setState(CefAppState.NEW);
        }
        return self;
    }

    public final void setSettings(CefSettings settings) throws IllegalStateException {
        if (CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CefAppState getState() {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            return state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setState(final CefAppState state) {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            state_ = state;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (appHandler_ != null) {
                    appHandler_.stateHasChanged(state);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState().ordinal()) {
            case 1: {
                CefApp.setState(CefAppState.TERMINATED);
                break;
            }
            case 2: 
            case 3: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.shutdown();
                    break;
                }
                HashSet<CefClient> clients = new HashSet<CefClient>(this.clients_);
                for (CefClient c : clients) {
                    c.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        switch (CefApp.getState().ordinal()) {
            case 1: {
                CefApp.setState(CefAppState.INITIALIZING);
                this.initialize();
            }
            case 2: 
            case 3: {
                CefClient client = new CefClient();
                this.clients_.add(client);
                return client;
            }
        }
        throw new IllegalStateException("Can't crate client in state " + String.valueOf((Object)state_));
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    protected final synchronized void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.shutdown();
        }
    }

    private final void initialize() {
        CefSettings settings;
        String jcefPath = CefApp.getJcefLibPath();
        System.out.println("initialize on " + String.valueOf(Thread.currentThread()) + " with library path " + jcefPath);
        CefSettings cefSettings = settings = this.settings_ != null ? this.settings_ : new CefSettings();
        if (OS.isWindows()) {
            Path jcefHelperPath = Paths.get(jcefPath, "jcef_helper.exe");
            settings.browser_subprocess_path = jcefHelperPath.normalize().toAbsolutePath().toString();
        } else if (OS.isMacintosh()) {
            String basePath;
            settings.main_bundle_path = basePath = Paths.get(jcefPath, new String[0]).getParent().getParent().toString();
            settings.framework_dir_path = basePath + "/Contents/Frameworks/Chromium Embedded Framework.framework";
            settings.locales_dir_path = basePath + "/Contents/Frameworks/Chromium Embedded Framework.framework/Resources";
            settings.resources_dir_path = basePath + "/Contents/Frameworks/Chromium Embedded Framework.framework/Resources";
            settings.browser_subprocess_path = basePath + "/Contents/Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper";
        } else if (OS.isLinux()) {
            settings.resources_dir_path = jcefPath;
            Path jcefHelperPath = Paths.get(jcefPath, "jcef_helper");
            settings.browser_subprocess_path = jcefHelperPath.normalize().toAbsolutePath().toString();
            Path localesPath = Paths.get(jcefPath, "locales");
            settings.locales_dir_path = localesPath.normalize().toAbsolutePath().toString();
        }
        if (this.N_Initialize(appHandler_, settings)) {
            CefApp.setState(CefAppState.INITIALIZED);
        }
    }

    protected final void handleBeforeTerminate() {
        this.macOSTerminationRequestRunnable.run();
    }

    private final void shutdown() {
        this.N_Shutdown();
        CefApp.setState(CefAppState.TERMINATED);
        self = null;
    }

    public final void doMessageLoopWork(long delay_ms) {
    }

    public static final boolean startup(String[] args) {
        String jcefPath = CefApp.getJcefLibPath();
        if (OS.isWindows()) {
            System.load(jcefPath + "/d3dcompiler_47.dll");
            System.load(jcefPath + "/libGLESv2.dll");
            System.load(jcefPath + "/libEGL.dll");
            System.load(jcefPath + "/chrome_elf.dll");
            System.load(jcefPath + "/libcef.dll");
            System.load(jcefPath + "/jcef.dll");
            return true;
        }
        if (OS.isMacintosh()) {
            System.load(jcefPath + "/libjcef.dylib");
            return CefApp.N_Startup(CefApp.getCefFrameworkPath(args));
        }
        if (OS.isLinux()) {
            System.load(jcefPath + "/libcef.so");
            System.load(jcefPath + "/libjcef.so");
            return CefApp.N_Startup(null);
        }
        return false;
    }

    private static final String getJcefLibPath() {
        Path librariesPath = Paths.get(System.getProperty("jcef.path"), new String[0]);
        Path jcefPath = OS.isMacintosh() ? librariesPath.resolve("jcef_app.app/Contents/Java") : librariesPath;
        return jcefPath.toAbsolutePath().toString();
    }

    private static final String getCefFrameworkPath(String[] args) {
        String switchPrefix = "--framework-dir-path=";
        for (String arg : args) {
            if (!arg.startsWith(switchPrefix)) continue;
            return new File(arg.substring(switchPrefix.length())).getAbsolutePath();
        }
        return new File(CefApp.getJcefLibPath() + "/../Frameworks/Chromium Embedded Framework.framework").getAbsolutePath();
    }

    private static final native boolean N_Startup(String var0);

    private final native boolean N_PreInitialize();

    private final native boolean N_Initialize(CefAppHandler var1, CefSettings var2);

    private final native void N_Shutdown();

    public final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public final class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(CefApp this$0, int jcefCommitNo, int cefMajor, int cefMinor, int cefPatch, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_VERSION_MINOR = cefMinor;
            this.CEF_VERSION_PATCH = cefPatch;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

