/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.example;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.cinemamod.mcef.example.ExampleTexture;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExampleScreen
extends Screen {
    private static final int BROWSER_DRAW_OFFSET = 20;
    private MCEFBrowser browser;
    protected ResourceLocation exampleLocation;
    protected ExampleTexture exampleTexture;

    public ExampleScreen(Component component) {
        super(component);
    }

    protected void init() {
        super.init();
        if (this.browser == null) {
            this.exampleLocation = ResourceLocation.fromNamespaceAndPath((String)"example", (String)("frame_" + UUID.randomUUID().toString().replace("-", "")));
            this.exampleTexture = new ExampleTexture(-1, this.exampleLocation.toString());
            String url = "https://www.google.com";
            boolean transparent = false;
            this.browser = MCEF.createBrowser(url, transparent);
            this.resizeBrowser();
            Minecraft.getInstance().getTextureManager().register(this.exampleLocation, (AbstractTexture)this.exampleTexture);
        }
    }

    private int mouseX(double x) {
        return (int)((x - 20.0) * (double)this.minecraft.getWindow().getGuiScale());
    }

    private int mouseY(double y) {
        return (int)((y - 20.0) * (double)this.minecraft.getWindow().getGuiScale());
    }

    private int scaleX(double x) {
        return (int)((x - 40.0) * (double)this.minecraft.getWindow().getGuiScale());
    }

    private int scaleY(double y) {
        return (int)((y - 40.0) * (double)this.minecraft.getWindow().getGuiScale());
    }

    private void resizeBrowser() {
        if (this.width > 100 && this.height > 100) {
            this.browser.resize(this.scaleX(this.width), this.scaleY(this.height));
        }
    }

    private void updateFrame() {
        this.exampleTexture.setId(this.browser.getRenderer().getTextureID());
        this.exampleTexture.setWidth(this.width);
        this.exampleTexture.setHeight(this.height);
    }

    public void resize(Minecraft minecraft, int i, int j) {
        super.resize(minecraft, i, j);
        this.resizeBrowser();
    }

    public void onClose() {
        this.browser.close();
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.updateFrame();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.exampleLocation, 20, 20, 0.0f, 0.0f, this.width - 40, this.height - 40, this.width - 40, this.height - 40, Color.white.getRGB());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.browser.sendMousePress(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.browser.sendMouseRelease(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.browser.sendMouseWheel(this.mouseX(mouseX), this.mouseY(mouseY), scrollY, 0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.browser.sendKeyPress(keyCode, scanCode, modifiers);
        this.browser.setFocus(true);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.browser.sendKeyRelease(keyCode, scanCode, modifiers);
        this.browser.setFocus(true);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (codePoint == '\u0000') {
            return false;
        }
        this.browser.sendKeyTyped(codePoint, modifiers);
        this.browser.setFocus(true);
        return super.charTyped(codePoint, modifiers);
    }
}

