/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.internal;

import com.cinemamod.mcef.internal.MCEFDownloadListener;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class MCEFDownloaderMenu
extends Screen {
    private final Screen menu;

    public MCEFDownloaderMenu(Screen menu) {
        super((Component)Component.literal((String)"MCEF is downloading required libraries..."));
        this.menu = menu;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        float cx = (float)this.width / 2.0f;
        float cy = (float)this.height / 2.0f;
        float progressBarHeight = 14.0f;
        float progressBarWidth = (float)this.width / 3.0f;
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(cx, cy);
        poseStack.translate(-progressBarWidth / 2.0f, -progressBarHeight / 2.0f);
        graphics.fill(0, 0, (int)progressBarWidth, (int)progressBarHeight, -1);
        graphics.fill(2, 2, (int)progressBarWidth - 2, (int)progressBarHeight - 2, -16777215);
        graphics.fill(4, 4, (int)((progressBarWidth - 4.0f) * MCEFDownloadListener.INSTANCE.getProgress()), (int)progressBarHeight - 4, -1);
        poseStack.popMatrix();
        String[] text = new String[]{MCEFDownloadListener.INSTANCE.getTask(), Math.round(MCEFDownloadListener.INSTANCE.getProgress() * 100.0f) + "%"};
        Objects.requireNonNull(this.font);
        int n = 9 / 2;
        Objects.requireNonNull(this.font);
        int oSet = n + (9 + 2) * (text.length + 2) + 4;
        poseStack.pushMatrix();
        poseStack.translate((float)((int)cx), (float)((int)(cy - (float)oSet)));
        graphics.drawString(this.font, String.valueOf(ChatFormatting.GOLD) + this.title.getString(), (int)(-((double)this.font.width(this.title.getString()) / 2.0)), 0, 0xFFFFFF);
        int index = 0;
        for (String s : text) {
            if (index == 1) {
                Objects.requireNonNull(this.font);
                poseStack.translate(0.0f, (float)(9 + 2));
            }
            Objects.requireNonNull(this.font);
            poseStack.translate(0.0f, (float)(9 + 2));
            graphics.drawString(this.font, s, (int)(-((double)this.font.width(s) / 2.0)), 0, 0xFFFFFF);
            ++index;
        }
        poseStack.pushMatrix();
    }

    public void tick() {
        if (MCEFDownloadListener.INSTANCE.isDone() || MCEFDownloadListener.INSTANCE.isFailed()) {
            this.onClose();
            Minecraft.getInstance().setScreen(this.menu);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return true;
    }
}

