/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFClient;
import com.cinemamod.mcef.MCEFDragContext;
import com.cinemamod.mcef.MCEFPlatform;
import com.cinemamod.mcef.MCEFRenderer;
import com.cinemamod.mcef.listeners.MCEFCursorChangeListener;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import net.minecraft.class_310;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserOsr;
import org.cef.callback.CefDragData;
import org.cef.event.CefKeyEvent;
import org.cef.event.CefMouseEvent;
import org.cef.event.CefMouseWheelEvent;
import org.cef.misc.CefCursorType;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class MCEFBrowser
extends CefBrowserOsr {
    private final MCEFRenderer renderer;
    private final MCEFDragContext dragContext = new MCEFDragContext();
    private MCEFCursorChangeListener cursorChangeListener;
    private boolean browserControls = true;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int btnMask = 0;
    protected ByteBuffer popupGraphics;
    protected Rectangle popupSize;
    protected boolean showPopup = false;
    protected boolean popupDrawn = false;

    public MCEFBrowser(MCEFClient client, String url, boolean transparent) {
        super(client.getHandle(), url, transparent, null);
        this.renderer = new MCEFRenderer(transparent);
        this.cursorChangeListener = cefCursorID -> this.setCursor(CefCursorType.fromId(cefCursorID));
        class_310.method_1551().method_20493(this.renderer::initialize);
    }

    public MCEFRenderer getRenderer() {
        return this.renderer;
    }

    public MCEFCursorChangeListener getCursorChangeListener() {
        return this.cursorChangeListener;
    }

    public void setCursorChangeListener(MCEFCursorChangeListener cursorChangeListener) {
        this.cursorChangeListener = cursorChangeListener;
    }

    public boolean usingBrowserControls() {
        return this.browserControls;
    }

    public MCEFBrowser useBrowserControls(boolean browserControls) {
        this.browserControls = browserControls;
        return this;
    }

    public MCEFDragContext getDragContext() {
        return this.dragContext;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        super.onPopupShow(browser, show);
        this.showPopup = show;
        if (!show) {
            this.popupDrawn = false;
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        super.onPopupSize(browser, size);
        this.popupSize = size;
        this.popupGraphics = ByteBuffer.allocateDirect(size.width * size.height * 4);
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (dirtyRects.length == 0) {
            return;
        }
        if (!popup) {
            if (this.lastWidth != width || this.lastHeight != height) {
                this.lastWidth = width;
                this.lastHeight = height;
                this.renderer.onPaint(buffer, width, height);
            } else {
                if (this.renderer.getTextureID() == 0) {
                    return;
                }
                GlStateManager._bindTexture((int)this.renderer.getTextureID());
                GlStateManager._pixelStore((int)3314, (int)width);
                for (Rectangle dirtyRect : dirtyRects) {
                    GlStateManager._pixelStore((int)3316, (int)dirtyRect.x);
                    GlStateManager._pixelStore((int)3315, (int)dirtyRect.y);
                    this.renderer.onPaint(buffer, dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
                }
                if ((this.popupDrawn || this.showPopup) && this.popupSize != null) {
                    if (!this.showPopup) {
                        GlStateManager._pixelStore((int)3316, (int)this.popupSize.width);
                        GlStateManager._pixelStore((int)3315, (int)this.popupSize.height);
                        this.renderer.onPaint(buffer, this.popupSize.x, this.popupSize.y, this.popupSize.width, this.popupSize.height);
                        this.popupGraphics = null;
                        this.popupSize = null;
                    } else if (this.popupDrawn) {
                        GlStateManager._pixelStore((int)3314, (int)this.popupSize.width);
                        GlStateManager._pixelStore((int)3316, (int)0);
                        GlStateManager._pixelStore((int)3315, (int)0);
                        this.renderer.onPaint(this.popupGraphics, this.popupSize.x, this.popupSize.y, this.popupSize.width, this.popupSize.height);
                    }
                }
            }
        } else {
            if (this.renderer.getTextureID() == 0) {
                return;
            }
            GlStateManager._bindTexture((int)this.renderer.getTextureID());
            int start = buffer.capacity();
            int end = 0;
            for (Rectangle dirtyRect : dirtyRects) {
                int rectEnd;
                GlStateManager._pixelStore((int)3314, (int)this.popupSize.width);
                GlStateManager._pixelStore((int)3316, (int)dirtyRect.x);
                GlStateManager._pixelStore((int)3315, (int)dirtyRect.y);
                this.renderer.onPaint(buffer, this.popupSize.x + dirtyRect.x, this.popupSize.y + dirtyRect.y, dirtyRect.width, dirtyRect.height);
                int rectStart = dirtyRect.x + dirtyRect.y * this.popupSize.width << 2;
                if (rectStart < start) {
                    start = rectStart;
                }
                if ((rectEnd = dirtyRect.x + dirtyRect.width + (dirtyRect.y + this.popupSize.height) * dirtyRect.width << 2) <= end) continue;
                end = rectEnd;
            }
            if (start < 0) {
                start = 0;
            }
            if (end > buffer.capacity()) {
                end = buffer.capacity();
            }
            if (end > start && this.popupGraphics != null) {
                long addrFrom = MemoryUtil.memAddress((ByteBuffer)buffer);
                long addrTo = MemoryUtil.memAddress((ByteBuffer)this.popupGraphics);
                MemoryUtil.memCopy((long)(addrFrom + (long)start), (long)(addrTo + (long)start), (long)(end - start));
            }
            this.popupDrawn = true;
        }
    }

    public void resize(int width, int height) {
        this.browser_rect_.setBounds(0, 0, width, height);
        this.wasResized(width, height);
    }

    public void sendKeyPress(int keyCode, long scanCode, int modifiers) {
        if (this.browserControls) {
            if (modifiers == 2) {
                if (keyCode == 82) {
                    this.reload();
                    return;
                }
                if (keyCode == 61) {
                    if (this.getZoomLevel() < 9.0) {
                        this.setZoomLevel(this.getZoomLevel() + 1.0);
                    }
                    return;
                }
                if (keyCode == 45) {
                    if (this.getZoomLevel() > -9.0) {
                        this.setZoomLevel(this.getZoomLevel() - 1.0);
                    }
                    return;
                }
                if (keyCode == 48) {
                    this.setZoomLevel(0.0);
                    return;
                }
            } else if (modifiers == 4) {
                if (keyCode == 263 && this.canGoBack()) {
                    this.goBack();
                    return;
                }
                if (keyCode == 262 && this.canGoForward()) {
                    this.goForward();
                    return;
                }
            }
        }
        CefKeyEvent e = new CefKeyEvent(1, keyCode, (char)keyCode, modifiers);
        e.scancode = scanCode;
        this.sendKeyEvent(e);
    }

    public void sendKeyRelease(int keyCode, long scanCode, int modifiers) {
        if (this.browserControls) {
            if (modifiers == 2) {
                if (keyCode == 82) {
                    return;
                }
                if (keyCode == 61) {
                    return;
                }
                if (keyCode == 45) {
                    return;
                }
                if (keyCode == 48) {
                    return;
                }
            } else if (modifiers == 4) {
                if (keyCode == 263 && this.canGoBack()) {
                    return;
                }
                if (keyCode == 262 && this.canGoForward()) {
                    return;
                }
            }
        }
        CefKeyEvent e = new CefKeyEvent(0, keyCode, (char)keyCode, modifiers);
        e.scancode = scanCode;
        this.sendKeyEvent(e);
    }

    public void sendKeyTyped(char c, int modifiers) {
        if (this.browserControls) {
            if (modifiers == 2) {
                if (c == 'R') {
                    return;
                }
                if (c == '=') {
                    return;
                }
                if (c == '-') {
                    return;
                }
                if (c == '0') {
                    return;
                }
            } else if (modifiers == 4) {
                if (c == '\u0107' && this.canGoBack()) {
                    return;
                }
                if (c == '\u0106' && this.canGoForward()) {
                    return;
                }
            }
        }
        CefKeyEvent e = new CefKeyEvent(2, c, c, modifiers);
        this.sendKeyEvent(e);
    }

    public void sendMouseMove(int mouseX, int mouseY) {
        CefMouseEvent e = new CefMouseEvent(503, mouseX, mouseY, 0, 0, this.dragContext.getVirtualModifiers(this.btnMask));
        this.sendMouseEvent(e);
        if (this.dragContext.isDragging()) {
            this.dragTargetDragOver(new Point(mouseX, mouseY), 0, this.dragContext.getMask());
        }
    }

    public void sendMousePress(int mouseX, int mouseY, int button) {
        if (button == 1) {
            button = 2;
        } else if (button == 2) {
            button = 1;
        }
        if (button == 0) {
            this.btnMask |= 0x10;
        } else if (button == 1) {
            this.btnMask |= 0x20;
        } else if (button == 2) {
            this.btnMask |= 0x40;
        }
        CefMouseEvent e = new CefMouseEvent(1, mouseX, mouseY, 1, button, this.btnMask);
        this.sendMouseEvent(e);
    }

    public void sendMouseRelease(int mouseX, int mouseY, int button) {
        if (button == 1) {
            button = 2;
        } else if (button == 2) {
            button = 1;
        }
        if (button == 0 && (this.btnMask & 0x10) != 0) {
            this.btnMask ^= 0x10;
        } else if (button == 1 && (this.btnMask & 0x20) != 0) {
            this.btnMask ^= 0x20;
        } else if (button == 2 && (this.btnMask & 0x40) != 0) {
            this.btnMask ^= 0x40;
        }
        CefMouseEvent e = new CefMouseEvent(0, mouseX, mouseY, 1, button, this.btnMask);
        this.sendMouseEvent(e);
        if (this.dragContext.isDragging() && button == 0) {
            this.finishDragging(mouseX, mouseY);
        }
    }

    public void sendMouseWheel(int mouseX, int mouseY, double amount, int modifiers) {
        if (this.browserControls && (modifiers & 2) != 0) {
            if (amount > 0.0) {
                if (this.getZoomLevel() < 9.0) {
                    this.setZoomLevel(this.getZoomLevel() + 1.0);
                }
            } else if (this.getZoomLevel() > -9.0) {
                this.setZoomLevel(this.getZoomLevel() - 1.0);
            }
            return;
        }
        if (!MCEFPlatform.getPlatform().isMacOS()) {
            amount = amount < 0.0 ? Math.floor(amount) : Math.ceil(amount);
            amount *= 3.0;
        }
        CefMouseWheelEvent e = new CefMouseWheelEvent(0, mouseX, mouseY, amount, modifiers);
        this.sendMouseWheelEvent(e);
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        this.dragContext.startDragging(dragData, mask);
        this.dragTargetDragEnter(this.dragContext.getDragData(), new Point(x, y), this.btnMask, this.dragContext.getMask());
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
        if (this.dragContext.updateCursor(operation)) {
            this.onCursorChange(this, this.dragContext.getVirtualCursor(this.dragContext.getActualCursor()));
        }
        super.updateDragCursor(browser, operation);
    }

    public void startDragging(CefDragData dragData, int mask, int x, int y) {
        this.startDragging(dragData, mask, x, y);
    }

    public void finishDragging(int x, int y) {
        this.dragTargetDrop(new Point(x, y), this.btnMask);
        this.dragTargetDragLeave();
        this.dragContext.stopDragging();
        this.onCursorChange(this, this.dragContext.getActualCursor());
    }

    public void cancelDrag() {
        this.dragTargetDragLeave();
        this.dragContext.stopDragging();
        this.onCursorChange(this, this.dragContext.getActualCursor());
    }

    public void close() {
        this.renderer.cleanup();
        this.cursorChangeListener.onCursorChange(0);
        super.close(true);
    }

    @Override
    protected void finalize() throws Throwable {
        class_310.method_1551().method_20493(this.renderer::cleanup);
        super.finalize();
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        cursorType = this.dragContext.getVirtualCursor(cursorType);
        this.cursorChangeListener.onCursorChange(cursorType);
        return super.onCursorChange(browser, cursorType);
    }

    public void setCursor(CefCursorType cursorType) {
        if (cursorType == CefCursorType.NONE) {
            GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212994);
        } else {
            GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212993);
            GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)MCEF.getGLFWCursorHandle(cursorType));
        }
    }
}

